// Version 0.4 
// Last Updated: 10/16/2000
// Used by ClusterManager

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.


package Alkindi.Services.InternalData;

import Alkindi.Data.Product;
import Alkindi.Data.Rating;
import java.util.Iterator;
import Alkindi.Data.ProductList;
import java.util.ArrayList;

/* 
$Header: UserClusterList.java, 23, 4/26/01 2:36:59 PM, Schwartz, Joe$
$Log: 
 23   Alkindi Development1.22        4/26/01 2:36:59 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 22   Alkindi Development1.21        4/26/01 1:46:08 PM   Schwartz, Joe   Moved
      to new package.
 21   Alkindi Development1.20        2/13/01 5:54:46 PM   Schwartz, Joe  
      Changed to account for new SparseRatingsArray class, used for base class
      of RatingSpacePoint.
 20   Alkindi Development1.19        1/26/01 5:48:30 PM   Schwartz, Joe  
      Improving efficiency.
 19   Alkindi Development1.18        1/23/01 1:45:47 PM   Schwartz, Joe  
      Modified to work with floats instead of doubles.
 18   Alkindi Development1.17        1/22/01 1:46:41 PM   Schwartz, Joe  
      Modified to account for new RatingSpacePoint base class of VMeans &
      UserCluster.
 17   Alkindi Development1.16        1/2/01 3:38:03 PM    Schwartz, Joe   Added
      more error info to exception handler in calcBadRecs().
 16   Alkindi Development1.15        12/28/00 1:07:28 PM  Schwartz, Joe   Added
      Version Control header info.
 15   Alkindi Development1.14        12/26/00 6:57:17 PM  Schwartz, Joe   
 14   Alkindi Development1.13        12/18/00 12:06:26 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 13   Alkindi Development1.12        12/15/00 6:18:37 PM  Schwartz, Joe  
      Changed to reflect modifications to UserRatings/UserRatingsList.
 12   Alkindi Development1.11        12/5/00 1:21:18 PM   Schwartz, Joe   
 11   Alkindi Development1.10        12/3/00 7:51:19 PM   Schwartz, Joe   
 10   Alkindi Development1.9         12/3/00 5:45:20 PM   Schwartz, Joe  
      Changed QuickProdStatsList to use HashMap
 9    Alkindi Development1.8         12/3/00 5:28:01 PM   Schwartz, Joe   
 8    Alkindi Development1.7         12/2/00 2:57:24 PM   Schwartz, Joe   
 7    Alkindi Development1.6         12/2/00 1:02:13 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/2/00 11:26:09 AM  Schwartz, Joe   
 5    Alkindi Development1.4         11/8/00 2:59:04 PM   Schwartz, Joe   
 4    Alkindi Development1.3         10/27/00 3:45:42 PM  Schwartz, Joe   Added
      method calcBadRecs(), to return the percentage of bad recs based on the
      current cluster list. Modified to use QuickProdStats.
 3    Alkindi Development1.2         10/22/00 10:38:48 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 2    Alkindi Development1.1         10/17/00 2:16:36 PM  Schwartz, Joe  
      Delivery 10.16.00
 1    Alkindi Development1.0         10/7/00 4:26:03 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents a list of UserCluster objects.
 */
public class UserClusterList implements Cloneable 
{
	private ArrayList internalList;
	private static final UserClusterList uclInstance = new UserClusterList();
	
	/**
	 * @roseuid 3A291B220242
	 */
	public final boolean add(UserCluster itemToAdd) 
	{
		return internalList.add(itemToAdd);
	}
	
	/**
	 * @roseuid 3A6F31B60213
	 */
	public UserCluster addCluster(final VMeans vm, final ProductList products) 
	{
		UserCluster newUC = UserCluster.getInstance(vm, products);
		internalList.add(newUC);
		return newUC;
	}
	
	/**
	 * @roseuid 3A293E5301C5
	 */
	public final void addUserToCluster(UserRatings userRatings, final int ID) 
	{
/*		Iterator it = iterator();
		while (it.hasNext()) {
			UserCluster uc = (UserCluster)it.next();
			if (uc.id == ID) {
				uc.userRatingsList.add(userRatings);
			}
		}*/
		((UserCluster)internalList.get(ID)).userRatingsList.add(userRatings);
	}
	
	/**
	 * @roseuid 3A291B2E0399
	 */
	public final double calcBadRecs(int pcid) throws Exception 
	{
		final int MAX_PRODS = 10;
		// Iterate over User Clusters
		//
		float totalGoodEvals = 0;
		float totalBadEvals = 0;
		
		try {
			for (int clusterIdx = this.size() ; --clusterIdx > -1; ) {
				float clusterGoodEvals = 0;
				float clusterBadEvals = 0;
	//			LogManager.dbgLog("UserClusterList", "calcBadRecs", "Analyzing user cluster #" + clusterIdx);
				UserCluster cluster = this.get(clusterIdx);
				//	If there are no users in the cluster, move on...
				//
				if (cluster.numUsers() < 1) {
					continue;
				}
				//			LogManager.dbgLog("UserClusterList", "calcBadRecs", "	cluster " + clusterIdx + " has " + cluster.ur.length + " users.");
				int numProd = cluster.userRatingsList.numProducts();
//				LogManager.dbgLog("UserClusterList", "calcBadRecs", "Num Prods in cluster " + clusterIdx + " = " + numProd);
				QuickProdStatsList StatsList = QuickProdStatsList.getInstance();

				//	Iterate over products / evaluations
				//
				Iterator itProd = cluster.userRatingsList.products.iterator();
				while (itProd.hasNext()) {
					Product prod = (Product)itProd.next();
	//				LogManager.dbgLog("UserClusterList", "calcBadRecs", "	product #" + prodIdx + " prodid = " + cluster.ur[0].product[prodIdx]) ;
					//	For each product, make a new QuickProdStats object
					//	and add to the vector of stats.
					//
					QuickProdStats qStats = QuickProdStats.getInstance();
					StatsList.add(prod, qStats);

					//	Get evaluations for each product
					//
					float numEvals = 0;
					Iterator userRatingsIt = cluster.userRatingsList.userRatingsIterator();
					while(userRatingsIt.hasNext()){
						UserRatings ur = (UserRatings)userRatingsIt.next();
						float eval = ur.getEval(prod.id);
						if (eval != 0) {
							qStats.addEval(eval);
						}
	//					LogManager.dbgLog("UserClusterList", "calcBadRecs", "			added eval=" + eval);
	//					if (eval > 0) {
	//						LogManager.dbgLog("UserClusterList", "calcBadRecs", "		" + qStats.toString());	
	//					}
					}
				}
				
				QuickProdStats topStats = StatsList.getTopNStats(MAX_PRODS);

				//	Take the MAX_PRODS products with the top average ratings 
				//	and add the number of good and bad
				//	evals to the totals.
				//
	/*			LogManager.dbgLog("UserClusterList", "calcBadRecs", "ProdDump:");
				for (int statIdx = 0; statIdx < arStats.length; statIdx++) {
					QuickProdStats item = (QuickProdStats)arStats[statIdx];
					LogManager.dbgLog("UserClusterList", "calcBadRecs", " pid=" + + " avg=" + item.getAvgEval());
				}*/
				StatsList = null;

				totalGoodEvals += topStats.getGoodEvals();
				totalBadEvals += topStats.getBadEvals();
			}
		}
		catch (Exception e) {
//LogManager.err("UserClusterList", "calcBadRecs", e.toString());
//			e.printStackTrace();
			throw (e);
		}
		float pctBad = totalBadEvals / (totalGoodEvals + totalBadEvals);
		return pctBad;
	}
	
	/**
	 * @roseuid 3A368979035B
	 */
	public final java.lang.String dump() 
	{
		String dumpStr = "*** UserClusterList ***\n";
		int totalUsers = 0;
		int maxUC = internalList.size();
		for (int ucIdx = 0; ucIdx < maxUC; ucIdx ++) {
			UserCluster uc = get(ucIdx);
			dumpStr += "UserCluster " + ucIdx + "\n" + uc.dump();
			totalUsers += uc.userRatingsList.numUsers();
		}
		dumpStr += " ***TOTAL: " + totalUsers + " users";
		return dumpStr;
	}
	
	/**
	 * @roseuid 3A291B250290
	 */
	public final UserCluster get(int idx) 
	{
		return (UserCluster) internalList.get(idx);
	}
	
	/**
	 * @roseuid 3A6F3D9602FD
	 */
	public static final UserClusterList getInstance(final int size) 
	{
		try {
			UserClusterList ucl = (UserClusterList)uclInstance.clone();
			ucl.internalList = (ArrayList)uclInstance.internalList.clone();
			ucl.internalList.clear();
			ucl.internalList.ensureCapacity(size);
			return ucl;			
		}
		catch (CloneNotSupportedException cne) {
			return null;
		}
	}
	
	/**
	 * @roseuid 3A6F3DC800AB
	 */
	public static final UserClusterList getInstance() 
	{
		return getInstance(0);
	}
	
	/**
	 * @roseuid 3A291B2701A5
	 */
	public final Iterator iterator() 
	{
		return internalList.iterator();
	}
	
	/**
	 * @roseuid 3A291B29005D
	 */
	public final int size() 
	{
		return internalList.size();
	}
	
	/**
	 * @roseuid 3A6F3E6E0148
	 */
	private UserClusterList() 
	{
		internalList = new ArrayList();
	}
}
